﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;

public partial class DataExportBioLab : System.Web.UI.Page
{
    private UserAccountManager _currentUser;
    
    protected void Page_Load(object sender, EventArgs e)
    {
        try
        {
            _currentUser = (UserAccountManager)HttpContext.Current.User;
        }
        catch 
        {
            Response.Redirect("ErrorPage.aspx?id=505");
        }

        // Check whether the user has EFR TEFSC COORDINATOR role
        if (_currentUser.GetRoles().Contains(4))
        {
            Response.ClearContent();
            Response.AddHeader("content-disposition", "attachment; filename=DataExport.xls");
            Response.ContentType = "application/vnd.ms-excel";
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //Some text values will mistakenly interpreted as numeric by Excel, such as postal codes and social security numbers
        //Such fields may loose their trailing zeros, such as zip code "00700" converts into number 700
        //Use the code below to explicitely convert affected columns into text format
        //Column numbers start with 0
        
        if (e.Row.RowType == DataControlRowType.DataRow) 
        {
            //MJ, 01/25/2011, Cells values are referenced by ColumnName instead of column Index
            GetCellsByBoundFieldName(e.Row, "SSN").ForEach(c => c.Attributes.Add("class", "text"));
            //GetCellByBoundFieldName(e.Row, "LAB_REFERENCE_RANGE").Attributes.Add("class", "text");
            GetCellsByBoundFieldName(e.Row, "LAB_REF_RGE").ForEach( c => c.Attributes.Add("class", "text"));
            GetCellsByBoundFieldName(e.Row, "TEF_REF_RGE").ForEach( c => c.Attributes.Add("class", "text"));

                        
         }
        //else if (e.Row.RowType == DataControlRowType.Header)
        //{


        //    using (StreamWriter writer = File.CreateText("C:\\Projects\\columns.txt"))
        //    {


        //        e.Row.Cells.Cast<TableCell>().ToList().ForEach(c => writer.WriteLine(c.Text));

        //    }
        //}         
    }

    public override void VerifyRenderingInServerForm(Control control)
    {
    }

    List<DataControlFieldCell> GetCellsByBoundFieldName(GridViewRow row, string fieldName)
    {
       
        return row.Cells.Cast<DataControlFieldCell>().Where(s => s.ContainingField.HeaderText.EndsWith(fieldName)).ToList(); 
    }


    protected void SqlDataSource1_Selecting(object sender, SqlDataSourceCommandEventArgs e)
    {
        int timeOutValue = Helpers.getIntFromString(Helpers.GetConfigEntry("CommandTimeout"));

        if (timeOutValue > 0)
        {
            e.Command.CommandTimeout = timeOutValue;
        }
        else
        {
            e.Command.CommandTimeout = Helpers.GetDefaultTimeout();
        }

    }

}
